%------------------------------------------------------------------------------
% File     : SWW971^5 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Software Verification
% Problem  : Conflict detection of 2 conceptual schemata (e.g. UML-schemata)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [BE04]  Boeva & Ekenberg (2004), A Transition Logic for Schema
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : APM002+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 0.50 v9.0.0, 0.25 v8.2.0, 0.50 v8.1.0
% Syntax   : Number of formulae    :   34 (  11 unt;  18 typ;  10 def)
%            Number of atoms       :   74 (  10 equ;   0 cnn)
%            Maximal formula atoms :   24 (   4 avg)
%            Number of connectives :   99 (   1   ~;   1   |;   3   &;  90   @)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   3 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   61 (  61   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   19 (  17 usr;   5 con; 0-3 aty)
%            Number of variables   :   33 (  25   ^;   6   !;   2   ?;  33   :)
% SPC      : TH0_CSA_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $constant,
%            $modalities == $modal_system_S5].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(mrel_euclidean,axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ W @ U )
        & ( mrel @ W @ V ) )
     => ( mrel @ U @ V ) ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] : ( A @ X @ W ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] : ( A @ X @ W ) ) ) ).

thf(a_decl,type,
    a: $i ).

thf(b_decl,type,
    b: $i ).

thf(c_decl,type,
    c: $i ).

thf(p_decl,type,
    p: $i > mworld > $o ).

thf(r_decl,type,
    r: $i > mworld > $o ).

thf(schema1,axiom,
    mlocal @ ( mand @ ( mor @ ( mnot @ ( r @ a ) ) @ ( r @ b ) ) @ ( mand @ ( mequiv @ ( r @ c ) @ ( r @ a ) ) @ ( mand @ ( mimplies @ ( r @ a ) @ ( mdia @ ( r @ b ) ) ) @ ( mimplies @ ( mnot @ ( r @ a ) ) @ ( mdia @ ( mand @ ( mnot @ ( r @ b ) ) @ ( mnot @ ( r @ c ) ) ) ) ) ) ) ) ).

thf(schema2,axiom,
    mlocal @ ( mand @ ( mimplies @ ( p @ a ) @ ( p @ b ) ) @ ( mand @ ( mor @ ( p @ c ) @ ( mnot @ ( p @ b ) ) ) @ ( mimplies @ ( mand @ ( p @ a ) @ ( p @ b ) ) @ ( mdia @ ( mnot @ ( p @ b ) ) ) ) ) ) ).

thf(integration_assertion,axiom,
    ( mlocal
    @ ( mforall_di
      @ ^ [X: $i] : ( mequiv @ ( p @ X ) @ ( r @ X ) ) ) ) ).

thf(con,conjecture,
    ( mlocal
    @ ^ [W: mworld] : $false ) ).

%------------------------------------------------------------------------------
